Attribute VB_Name = "MdlFileRdWt"
Option Explicit

Public Const cnt_CSV_WRITE_VER025 = "0.25"  'Analysis Ver 1.000
Public Const cnt_CSV_WRITE_VER100 = "1.00"  'Analysis Ver 2.002
Public Const cnt_CSV_WRITE_VER210 = "2.100" 'Analysis Ver 2.100
Public Const cnt_CSV_WRITE_VER220 = "2.200" 'Analysis Ver 2.200
Public Const cnt_CSV_WRITE_VER230 = "2.300" 'Analysis Ver 2.300
Public Const cnt_CSV_WRITE_VER300 = "3.000" 'Analysis Ver 3.000

Public Const cnt_CSV_XTAL_VER100 = "1.000"  'Analysis Ver 3.100

Public Const Unit_OpenZ0 = 0
Public Const Unit_OpenDelay = 1
Public Const Unit_OpenLoss = 2
Public Const Unit_OpenCapC0 = 3
Public Const Unit_OpenCapC1 = 4
Public Const Unit_OpenCapC2 = 5
Public Const Unit_OpenCapC3 = 6
Public Const Unit_ShortZ0 = 7
Public Const Unit_ShortDelay = 8
Public Const Unit_ShortLoss = 9
Public Const Unit_ShortIndL0 = 10
Public Const Unit_ShortIndL1 = 11
Public Const Unit_ShortIndL2 = 12
Public Const Unit_ShortIndL3 = 13
Public Const Unit_LoadZ0 = 14
Public Const Unit_LoadDelay = 15
Public Const Unit_LoadLoss = 16
Public Const Unit_LoadResistance = 17

Public Const Unit_OpenR = 0
Public Const Unit_OpenL = 1
Public Const Unit_OpenC = 2
Public Const Unit_ShortR = 7
Public Const Unit_ShortL = 8
Public Const Unit_ShortC = 9
Public Const Unit_LoadR = 14
Public Const Unit_LoadL = 15
Public Const Unit_LoadC = 16

Public Const cnt_READ As Integer = 0
Public Const cnt_SAVE As Integer = 1

Public Const cnt_CSV_SEPA_CHAR = ","
Public Const cnt_CSV_SEPA_2ndCHAR = ";"

Public Const cnt_CHECK_APPLI_NAME = "Analysis"
Public Const cnt_CHECK_APPLI_XTAL = "Analysis_Xtal"

Public Const cnt_APP_NAME_TITLE = "Application Name"
Public Const cnt_CSV_SHET_TITLE = "CSV Sheet Revsion"
Public Const cnt_BD__NUMB_TITLE = "Board Number"
Public Const cnt_IP__ADDR_TITLE = "IP Address"
Public Const cnt_PD__NAME_TITLE = "Product Name"
Public Const cnt_PD_SERNO_TITLE = "Serial Number"
Public Const cnt_SW_BOX___TITLE = "SW-BOX Type"
Public Const cnt_CH__NO___TITLE = "Channel Title"
Public Const cnt_ELE__LEN_TITLE = "Electrical length correction (ON/OFF)"
Public Const cnt_ELE__TIM_TITLE = "Electrical length correction (psec)"
Public Const cnt_ELE_LENG_TITLE = "Electrical length correction (mm)"
Public Const cnt_PORT_EXT_TITLE = "Port Extension (ON/OFF)"     '*** CSV Rev.3.000 Add ***
Public Const cnt_PORT_TIM_TITLE = "Port Extension (psec)"       '*** CSV Rev.3.000 Add ***
Public Const cnt_PORT_LEN_TITLE = "Port Extension (mm)"         '*** CSV Rev.3.000 Add ***
Public Const cnt_PORT_IMP_TITLE = "Port Impedance (ohm)"
Public Const cnt_PARA_CNV_TITLE = "Parameter conversion (OFF / Z:TRAN / Y:TRAN / Z:REFL / Y:REFL / 1/S)"
Public Const cnt_CAL______TITLE = "Calibration Title"
Public Const cnt_CAL_INFO_TITLE = "Information on Calibration"
Public Const cnt_CAL_TIME_TITLE = "Get Calibration Time"
Public Const cnt_CAL1_STS_TITLE = "Cal1 Status"
Public Const cnt_CAL2_STS_TITLE = "Cal2 Status"
Public Const cnt_CAL3_STS_TITLE = "Cal3 Status"
Public Const cnt_CAL4_STS_TITLE = "Cal4 Status"
Public Const cnt_CAL_STAT_TITLE = "CAL status (ON/OFF)"
Public Const cnt_CAL_COR__TITLE = "CAL status (Cor/C?/C!)"
Public Const cnt_CAL_METH_TITLE = "CAL Method (Norm / Trans / 1 Port)"
Public Const cnt_CAL_TYPE_TITLE = "CAL Type (Don't@Care / User Define / 3.5mm / 3.5mm(R&S))"
Public Const cnt_CAL_SEXT_TITLE = "User Cal Kit Connect Type (Female/Male)"

Public Const cnt_STDOITME_TITLE = "Standard Cal Kit OPEN Item Title"
Public Const cnt_OP_IMP_R_TITLE = "OPEN Imp Rs [ohm]"
Public Const cnt_OP_IMP_L_TITLE = "OPEN Imp Ls [H]"
Public Const cnt_OP_IMP_C_TITLE = "OPEN Cap Cp [F]"
Public Const cnt_CALOITME_TITLE = "User Cal Kit OPEN Item Title"
Public Const cnt_OPEN_Z0__TITLE = "OPEN Z0[ohm]"
Public Const cnt_OPEN_DEL_TITLE = "OPEN Delay[ps]"
Public Const cnt_OPEN_LOS_TITLE = "OPEN Loss[G ohm/s]"
Public Const cnt_OPEN_C0__TITLE = "OPEN C0[e-15] F"
Public Const cnt_OPEN_C1__TITLE = "OPEN C1[e-27] F/Hz"
Public Const cnt_OPEN_C2__TITLE = "OPEN C2[e-36] F/Hz2"
Public Const cnt_OPEN_C3__TITLE = "OPEN C3[e-45] F/Hz3"
Public Const cnt_CAL_OPEN_TITLE = "OPEN Calibration data"

Public Const cnt_STDSITEM_TITLE = "Standard Cal Kit SHORT Item Title"
Public Const cnt_SH_IMP_R_TITLE = "SHORT Imp Rs [ohm]"
Public Const cnt_SH_IMP_L_TITLE = "SHORT Imp Ls [H]"
Public Const cnt_SH_IMP_C_TITLE = "SHORT Cap Cp [F]"
Public Const cnt_CALSITEM_TITLE = "User Cal Kit SHORT Item Title"
Public Const cnt_SHORT_Z0_TITLE = "SHORT Z0[ohm]"
Public Const cnt_SHORT_DE_TITLE = "SHORT Delay[ps]"
Public Const cnt_SHORT_LO_TITLE = "SHORT Loss[G ohm/s]"
Public Const cnt_SHORT_L0_TITLE = "SHORT L0[e-12] H"
Public Const cnt_SHORT_L1_TITLE = "SHORT L1[e-24] H/Hz"
Public Const cnt_SHORT_L2_TITLE = "SHORT L2[e-33] H/Hz2"
Public Const cnt_SHORT_L3_TITLE = "SHORT L3[e-42] H/Hz3"
Public Const cnt_CAL_SHOR_TITLE = "SHORT Calibration data"

Public Const cnt_STDLITEM_TITLE = "Standard Cal Kit LOAD Item Title"
Public Const cnt_LO_IMP_R_TITLE = "LOAD Imp Rs [ohm]"
Public Const cnt_LO_IMP_L_TITLE = "LOAD Imp Ls [H]"
Public Const cnt_LO_IMP_C_TITLE = "LOAD Cap Cp [F]"
Public Const cnt_CALLITEM_TITLE = "User Cal Kit LOAD Item Title"
Public Const cnt_LOAD_Z0__TITLE = "LOAD Z0[ohm]"
Public Const cnt_LOAD_DEL_TITLE = "LOAD Delay[ps]"
Public Const cnt_LOAD_LOS_TITLE = "LOAD Loss"
Public Const cnt_LOAD_RES_TITLE = "LOAD Resistance  [ohm]"
Public Const cnt_CAL_LOAD_TITLE = "LOAD Calibration data"

Public Const cnt_PRT_SWP__TITLE = "Part Sweep Title"
Public Const cnt_PRT_SWS__TITLE = "Part Sweep (ON/OFF)"
Public Const cnt_PRT_STP__TITLE = "START Point"
Public Const cnt_PRT_SPP__TITLE = "STOP Point"
Public Const cnt_PRT_SET__TITLE = "Part Sweep Setting"
Public Const cnt_SWEEP_TM_TITLE = "Sweep Time (ms)"
Public Const cnt_FRQ_SEGM_TITLE = "Number of Freq.Segment"
Public Const cnt_SEG_NO___TITLE = "Segment Number"
Public Const cnt_FRQ_STAR_TITLE = "START[MHz]"
Public Const cnt_FRQ_STOP_TITLE = "STOP[MHz]"
Public Const cnt_FRQ_POIN_TITLE = "POINT"
Public Const cnt_FRQ_STPW_TITLE = "START POWER[dBm]"
Public Const cnt_FRQ_SPPW_TITLE = "STOP POWER[dBm]"
Public Const cnt_FRQ_RBW__TITLE = "RBW[KHZ]"
Public Const cnt_FRQ_STTM_TITLE = "SettlingTime[msec]"
Public Const cnt_MARKER___TITLE = "Marker Title"
Public Const cnt_ALL_MKR__TITLE = "All Marker Display (ON/OFF)"
Public Const cnt_MKR_LIST_TITLE = "Marker list (ON/OFF)"
Public Const cnt_ACT_MKR__TITLE = "Active marker number"
Public Const cnt_MKR_OVRL_TITLE = "Overlap Disp Format"
Public Const cnt_MKR_CMPS_TITLE = "Compensate (ON/OFF)"     '*** CSV Rev.3.000 ***
Public Const cnt_MKR_CMPL_TITLE = "Compensate Local"        '*** CSV Rev.3.000 ***
Public Const cnt_MKR_CMPZ_TITLE = "Compensate Zero"         '*** CSV Rev.3.000 ***
Public Const cnt_MARKER_I_TITLE = "Information on marker"
Public Const cnt_MKR_NUMB_TITLE = "Marker Number"
Public Const cnt_MKR_DISP_TITLE = "Marker Display (ON/OFF)"
Public Const cnt_MKR_FREQ_TITLE = "Marker Freq."
Public Const cnt_MKR_POIN_TITLE = "Marker Point"
Public Const cnt_MEAS_____TITLE = "Measurement"
Public Const cnt_ACT_FORM_TITLE = "Active Format(LogMag/POLAR/Smith/DELAY/SWR/REAL/IMAG/Overlap)"
Public Const cnt_PHS_DISP_TITLE = "Phase (ON/OFF)"
Public Const cnt_MEAS_FMT_TITLE = "Measurement Format"
Public Const cnt_MEAS_MAX_TITLE = "Max Point"
Public Const cnt_MEAS_MIN_TITLE = "Min Point"
Public Const cnt_MEAS_0DG_TITLE = "0deg Point"
Public Const cnt_FMT_INF__TITLE = "Information on format "
Public Const cnt_FMT_DIV__TITLE = "/DIV"
Public Const cnt_FMT_REFV_TITLE = "Ref.VAL"
Public Const cnt_FMT_REFP_TITLE = "Ref.Pos"
Public Const cnt_FMT_LGM__TITLE = "LOGMAG"
Public Const cnt_FMT_PHS__TITLE = "PHASE"
Public Const cnt_FMT_DEL__TITLE = "DELAY"
Public Const cnt_FMT_SWR__TITLE = "SWR"
Public Const cnt_FMT_OVR__TITLE = "Overlap Format Title"
Public Const cnt_FMT_OLOG_TITLE = "LOGMAG"
Public Const cnt_FMT_OPOL_TITLE = "POLAR"
Public Const cnt_FMT_OSMI_TITLE = "Smith"
Public Const cnt_FMT_ODEL_TITLE = "DELAY"
Public Const cnt_FMT_OSWR_TITLE = "SWR"
Public Const cnt_FMT_OVRS_TITLE = "Overlap ON/OFF"
Public Const cnt_TRC_TIME_TITLE = "Measured Sweep Time"
Public Const cnt_TRC_POIN_TITLE = "Number of Trace Points"
Public Const cnt_TRC_NO___TITLE = "Measurement Number"
Public Const cnt_FMT_MEAS_FREQ = "Freq"
Public Const cnt_FMT_MEAS_LOGM = "LogMag"
Public Const cnt_FMT_MEAS_PHAS = "Phase"
Public Const cnt_FMT_MEAS_LINM = "LinMag"
Public Const cnt_FMT_MEAS_REAL = "Real"
Public Const cnt_FMT_MEAS_IMAG = "Imag"
Public Const cnt_FMT_MEAS_DELA = "Delay"
Public Const cnt_FMT_MEAS__SWR = "SWR"
Public Const cnt_MEM_TR_NUM_TT = "Numerical of Memory Trace"
Public Const cnt_MEM_TRC_NO_TT = "Memory Trace Number"
Public Const cnt_MEM_TRC_DSPTT = "Memory Trace Display"
Public Const cnt_MEM_MES_NO_TT = "Memory Measurement Number"
Public Const cnt_XTL_ITEM_TITLE = "Measurement Item Title"
Public Const cnt_XTL_FR___TITLE = "Fr Search (ON/OFF)"
Public Const cnt_XTL_EQU__TITLE = "Equivalent Constants (ON/OFF)"
Public Const cnt_XTL_FL___TITLE = "FL Measurement (ON/OFF)"
Public Const cnt_XTL_MEAS_TITLE = "Measurement Item Setting"
Public Const cnt_XTL_LMT__TITLE = "Result Limit"
Public Const cnt_XTL_LMT_C0_TTL = "C0"
Public Const cnt_XTL_LMT_C1_TTL = "C1"
Public Const cnt_XTL_LMT_L1_TTL = "L1"
Public Const cnt_XTL_LMT_R1_TTL = "R1"
Public Const cnt_XTL_LMT_Q__TTL = "Q"
Public Const cnt_XTL_LMT_Fr_TTL = "Fr"
Public Const cnt_XTL_LMT_CI_TTL = "CI"
Public Const cnt_XTL_LMT_FL_TTL = "FL"
Public Const cnt_XTL_LMTU_TITLE = "Upper Limit"
Public Const cnt_XTL_LMTL_TITLE = "Lower Limit"

Public Const cnt_XTAL_CFREQ = "CENTER[kHz]"
Public Const cnt_XTAL_SPAN = "SPAN[ppm]"

Public Const cnt_FREQ_TO_STR = "0.0000000000E-0"
Public Const cnt_FREQ_ADJUST As Double = 0.00000000005

Public Const cnt_RBW_TO_STR = "0.000000E-0"
Public Const cnt_RBW_ADJUST As Double = 0.0000005

Public Const cnt_STTM_TO_STR = "0.000000E-0"
Public Const cnt_STTM_ADJUST As Double = 0.0000005

Public Const cnt_LEVL_TO_STR = "0.000000E-0"

Public Const cnt_INT_TO_STR As Integer = 0
Public Const cnt_STR_TO_INT As Integer = 1

Public Const GOHM = 1000000000#
Public Const PS = 0.000000000001
Public Const Millimeter = 0.001
Public Const CapC0 = 0.000000000000001
Public Const CapC1 = 1E-27
Public Const CapC2 = 1E-36
Public Const CapC3 = 1E-45
Public Const IndL0 = 0.000000000001
Public Const IndL1 = 1E-24
Public Const IndL2 = 1E-33
Public Const IndL3 = 1E-42


'
' One-line read & line counter
'
Private Function getline(ByRef fileno As Long, ByVal lcnt As Long, ByRef aryTemp As Variant, ByRef s As String) As Long
    Dim textline As Variant
    
    lcnt = lcnt + 1
    Line Input #fileno, textline
    If 0 < InStr(1, textline, cnt_CSV_SEPA_2ndCHAR) Then s = cnt_CSV_SEPA_2ndCHAR
    aryTemp = Split(textline, s)
    getline = lcnt
End Function
'
' Reading of measurement condition from CSV Sheet
'
Private Function getdata(ByRef fileno As Long, ByVal lcnt As Long, ByRef vntTemp As Variant, ByRef s As String) As Long
    Dim lngTemp As Long

    lcnt = getline(fileno, lcnt, vntTemp, s)
    getdata = lcnt
End Function

'
'The value of ON/OFF or the character string is returned.
'
Public Sub CnvOnOffSw(ByVal flg As Integer, ByRef ss As String, ByRef sw As Integer)

    If flg = cnt_INT_TO_STR Then    'sw ->  return ss  = "ON" or "OFF"
        Select Case sw
            Case 0: ss = "OFF"
            Case 1: ss = "ON"
            Case Else: ss = "OFF"
        End Select
    Else                            ' ss -> return sw  = 0 or 1
        Select Case UCase$(ss)
            Case "OFF": sw = 0
            Case "ON": sw = 1
            Case Else: sw = 0
        End Select
    End If

End Sub

Private Function RdWtMeasData(ByRef fno As Long, ByVal line_cnt As Long, ByRef vntData As Variant, ByRef s As String, ByVal rdwt_flg As Integer) As Long
    
    If rdwt_flg = cnt_READ Then
        line_cnt = getdata(fno, line_cnt, vntData, s)
    Else
        Print #fno, vntData
        line_cnt = line_cnt + 1
    End If
    
    RdWtMeasData = line_cnt

End Function

'*************************************************
'  Function name  Fsubstdunit
'  Function    FUnit adjustment.
'  Functional descriptionsF
'*************************************************
Public Function substdunit(code As Integer) As Double
    Select Case code
        Case Unit_OpenL, Unit_ShortL, Unit_LoadL: substdunit = Unit_p   ' 1E-12 = p
        Case Unit_OpenC, Unit_ShortC, Unit_LoadC: substdunit = Unit_f   ' 1E-15 = f
        Case Else: substdunit = 1
    End Select

End Function

'*************************************************
'  Function name  Fsubunit
'  Function    FUnit adjustment.
'  Functional descriptionsF
'*************************************************
Public Function subunit(code As Integer) As Double
    
    Select Case code
        Case Unit_OpenDelay, Unit_ShortDelay, Unit_LoadDelay:
            subunit = PS
        Case Unit_OpenLoss, Unit_ShortLoss, Unit_LoadLoss:
            subunit = GOHM
            
        Case Unit_OpenCapC0: subunit = CapC0
        Case Unit_OpenCapC1: subunit = CapC1
        Case Unit_OpenCapC2: subunit = CapC2
        Case Unit_OpenCapC3: subunit = CapC3
        
        Case Unit_ShortIndL0: subunit = IndL0
        Case Unit_ShortIndL1: subunit = IndL1
        Case Unit_ShortIndL2: subunit = IndL2
        Case Unit_ShortIndL3: subunit = IndL3
        
        Case Else: subunit = 1
    End Select
    
End Function

Public Sub SetStdCalKit_Data(ByRef CKit As structStdCKit, ByVal code As Integer, ByVal dt As Double)
    
    dt = dt * substdunit(code)
    
    With CKit
        Select Case code
                Case Unit_OpenR:        .opRs = dt
                Case Unit_OpenL:        .opLs = dt
                Case Unit_OpenC:        .opCp = dt
                Case Unit_ShortR:       .shRs = dt
                Case Unit_ShortL:       .shLs = dt
                Case Unit_ShortC:       .shCp = dt
                Case Unit_LoadR:        .loRs = dt
                Case Unit_LoadL:        .loLs = dt
                Case Unit_LoadC:        .loCp = dt
        End Select
    End With

End Sub

Public Sub SetUserDefCalKit_Data(code As Integer, dt As Double)
    
    dt = dt * subunit(code)
    
    Select Case code
        Case Unit_OpenZ0:           CKit.UserDef.op_imp = dt
        Case Unit_OpenDelay:        CKit.UserDef.op_del = dt
        Case Unit_OpenLoss:         CKit.UserDef.op_loss = dt
        Case Unit_OpenCapC0:        CKit.UserDef.dblCap(0) = dt
        Case Unit_OpenCapC1:        CKit.UserDef.dblCap(1) = dt
        Case Unit_OpenCapC2:        CKit.UserDef.dblCap(2) = dt
        Case Unit_OpenCapC3:        CKit.UserDef.dblCap(3) = dt
        Case Unit_ShortZ0:          CKit.UserDef.sh_imp = dt
        Case Unit_ShortDelay:       CKit.UserDef.sh_del = dt
        Case Unit_ShortLoss:        CKit.UserDef.sh_loss = dt
        Case Unit_ShortIndL0:       CKit.UserDef.dblind(0) = dt
        Case Unit_ShortIndL1:       CKit.UserDef.dblind(1) = dt
        Case Unit_ShortIndL2:       CKit.UserDef.dblind(2) = dt
        Case Unit_ShortIndL3:       CKit.UserDef.dblind(3) = dt
        Case Unit_LoadZ0:           CKit.UserDef.lo_imp = dt
        Case Unit_LoadDelay:        CKit.UserDef.lo_del = dt
        Case Unit_LoadLoss:         CKit.UserDef.lo_loss = dt
        Case Unit_LoadResistance:   CKit.UserDef.lo_res = dt
    End Select

End Sub

Private Function ReadMeasData(fn As String, fileno As Long) As Boolean
    Dim lcnt As Long
    Dim s As String
    Dim aryTemp As Variant
    Dim aryOverlap As Variant
    Dim strAppliName As String
    Dim strCsvVer As String
    Dim strBoardIdn As String
    Dim int_sw As Integer
    Dim Z0 As Double
    Dim strTmp As String
    Dim i As Integer
    Dim seg_cnt As Integer
    Dim RdBdId As Long
    Dim n As Integer
    Dim tr As Integer
    Dim MinFreq As Double
    Dim MaxFreq As Double
    '
    ' It reads it from the CSV file.
    ' The read value is set to the variable.
    '
    ReadMeasData = True
    On Error GoTo ErrReadFile   'If file error is the specifies JUMP.
    '
    s = cnt_CSV_SEPA_CHAR
    
    lcnt = 0
    
    ' Application Name
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strAppliName = CStr(aryTemp(1))
    
    If UCase(strAppliName) <> UCase(cnt_CHECK_APPLI_NAME) Then GoTo ErrReadFile
    
    ' CSV Sheet Revsion
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strCsvVer = CDbl(aryTemp(1))
    
    ' Board Number
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    RdBdId = CLng(aryTemp(1))
    
    ' IP Address
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    If frmMain.Cmd_connect.Enabled = True Then
        frmMain.Text_con.Text = CStr(aryTemp(1))
    End If
    
    ' Product Name
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    NA_ProductName = CStr(aryTemp(1))
    If frmMain.Cmd_connect.Enabled = False Then
        If NA_ConnectProductName <> NA_ProductName Then
            MsgBox "Connect Product Name [ " & NA_ConnectProductName & " ]: " & vbCrLf & vbCrLf & _
                    "Read Product Name [ " & NA_ProductName & " ]", vbOKOnly Or vbCritical
            GoTo ErrProductType
        End If
    End If
    
    BdId = RdBdId
    
    ' Serial Number
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    NA_SerialNumber = CStr(aryTemp(1))
    
    ' SW-BOX Type
    If CDbl(cnt_CSV_WRITE_VER300) <= CDbl(strCsvVer) Then
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        If frmMain.Cmd_connect.Enabled <> True Then             ' Connect
            If strExpSwBoxType <> CStr(aryTemp(1)) Then
                MsgBox "Connect SW-BOX Name [ " & strExpSwBoxType & " ]: " & vbCrLf & vbCrLf & _
                            "Read SW-BOX Name [ " & aryTemp(1) & " ]", vbOKOnly Or vbCritical
                GoTo ErrProductType
            Else
                strExpSwBoxType = CStr(aryTemp(1))
                If strExpSwBoxType = SWBOX_TYPE_DPDT Then
                    Call ExpSwBoxType(lngExpSwBox, strExpSwBoxType, McrGetNo)
                End If
                If strExpSwBoxType = SWBOX_TYPE_SP4T Then
                    Call ExpSwBoxType(lngExpSwBox, strExpSwBoxType, McrGetNo)
                    SP4TPort(BdId, ActCh(BdId)) = CLng(aryTemp(2)) - 1
                End If
            End If
        Else
            strExpSwBoxType = CStr(aryTemp(1))
            If strExpSwBoxType = SWBOX_TYPE_DPDT Then
                Call ExpSwBoxType(lngExpSwBox, strExpSwBoxType, McrGetNo)
            End If
            If strExpSwBoxType = SWBOX_TYPE_SP4T Then
                Call ExpSwBoxType(lngExpSwBox, strExpSwBoxType, McrGetNo)
                SP4TPort(BdId, ActCh(BdId)) = CLng(aryTemp(2)) - 1
            End If
        End If
        
    End If

    ' Channel Title
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    ActCh(BdId) = CInt(Mid(aryTemp(1), 3, 1)) - 1
    frmMain.Combo_ch.ListIndex = ActCh(BdId)

    ' Electrical length correction (ON/OFF)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
'    frmMain.Check_EleCor.Value = int_sw
    EleCorrStat = int_sw
    
    ' Electrical length correction (psec)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    EleCorrTime = CDbl(aryTemp(1)) * PS
    
    If CDbl(cnt_CSV_WRITE_VER100) < CDbl(strCsvVer) Then
        ' Electrical length correction (mm)
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        EleCorrLength = CDbl(aryTemp(1)) * Millimeter
    End If
    
    If CDbl(cnt_CSV_WRITE_VER230) < CDbl(strCsvVer) Then
        ' Port Extension (ON/OFF)   <--- Add Rev 3.000
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
        PortExtStat = int_sw
        ' Port Extension (psec)     <--- Add Rev 3.000
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        PortExtTime = CDbl(aryTemp(1)) * PS
        ' Port Extension (mm)       <--- Add Rev 3.000
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        PortExtLength = CDbl(aryTemp(1)) * Millimeter
    Else
        PortExtStat = BIS_OFF
        PortExtTime = 0
    End If
    
    ' Port Impedance (ohm)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Z0 = CDbl(aryTemp(1))
    frmMain.Text_z0.Text = Z0
    
    ' Parameter conversion (OFF Z:TRAN Y:TRAN Z:REFL Y:REFL 1/S)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    For i = 0 To frmMain.Combo_cnv.ListCount
        If strTmp = frmMain.Combo_cnv.List(i) Then
            frmMain.Combo_cnv.ListIndex = i
            Exit For
        End If
    Next i
   
    ' Calibration Title
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
   
    ' CAL status (ON/OFF)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
    RdCorOn = int_sw
    If UBound(aryTemp) = 6 Then         'CSV Ver. 1 correspond
        strGetCalDateTime = aryTemp(2)
        CorAcq(0) = CLng(aryTemp(3))
        CorAcq(1) = CLng(aryTemp(4))
        CorAcq(2) = CLng(aryTemp(5))
        CorAcq(3) = CLng(aryTemp(6))
    End If
    
    ' CAL status (Cor/C?/C!)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    frmMain.Text_hd(0).Text = CStr(aryTemp(1))
    If aryTemp(1) = "Cor" Then
        CorOn = 1
    ElseIf aryTemp(1) = "C?" Then
        CorOn = 2
    ElseIf aryTemp(1) = "C!" Then
        CorOn = 3
    Else
        CorOn = 0
    End If
    
   
    ' CAL Method (Norm/Trans/1 Port)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    For i = 0 To frmMain.Combo_cal.ListCount
        If strTmp = frmMain.Combo_cal.List(i) Then
            CorMeth = i
            Exit For
        End If
    Next i
    
    ' CAL Type (Don't@Care / User Define / 3.5mm / 3.5mm(R&S))
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    For i = 0 To frmMain.Combo_CalKitType.ListCount
        If strTmp = frmMain.Combo_CalKitType.List(i) Then
            CKit.CKitType = i
            Exit For
        End If
    Next i
  
    ' User Cal Kit Connect Type (Female/Male)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    For i = 0 To frmMain.OptPortSexType.UBound
        If strTmp = frmMain.OptPortSexType(i).Caption Then
            If i = 0 Then
                CKit.PortSex = BIS_FEMALE
            Else
                CKit.PortSex = BIS_MALE
            End If
            Exit For
        End If
    Next i
    
    If 0 < InStr(NA_ProductName, PN_R3760__) Then
        'User Cal Kit OPEN Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'OPEN Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_OpenZ0 To Unit_OpenCapC3
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i + 1)))
        Next i
        
        'User Cal Kit SHORT Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'SHORT Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_ShortZ0 To Unit_ShortIndL3
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i - Unit_OpenCapC3)))
        Next i
        
        'User Cal Kit LOAD Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'LOAD Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_LoadZ0 To Unit_LoadResistance
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i - Unit_ShortIndL3)))
        Next i
    Else
        'Standard Cal Kit OPEN Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'OPEN Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        With StdCKit
            If CDbl(cnt_CSV_WRITE_VER210) < CDbl(strCsvVer) Then
                Call SetStdCalKit_Data(StdCKit, Unit_OpenR, CDbl(aryTemp(1)))
                Call SetStdCalKit_Data(StdCKit, Unit_OpenL, CDbl(aryTemp(2)))
                Call SetStdCalKit_Data(StdCKit, Unit_OpenC, CDbl(aryTemp(3)))
            Else
                .opRs = CDbl(aryTemp(1))
                .opLs = CDbl(aryTemp(2))
                .opCp = CDbl(aryTemp(3))
            End If
        End With
        
        'Standard Cal Kit SHORT Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'SHORT Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        With StdCKit
            If CDbl(cnt_CSV_WRITE_VER210) < CDbl(strCsvVer) Then
                Call SetStdCalKit_Data(StdCKit, Unit_ShortR, CDbl(aryTemp(1)))
                Call SetStdCalKit_Data(StdCKit, Unit_ShortL, CDbl(aryTemp(2)))
                Call SetStdCalKit_Data(StdCKit, Unit_ShortC, CDbl(aryTemp(3)))
            Else
                .shRs = CDbl(aryTemp(1))
                .shLs = CDbl(aryTemp(2))
                .shCp = CDbl(aryTemp(3))
            End If
        End With
        
        'Standard Cal Kit LOAD Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'LOAD Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        With StdCKit
            If CDbl(cnt_CSV_WRITE_VER210) < CDbl(strCsvVer) Then
                Call SetStdCalKit_Data(StdCKit, Unit_LoadR, CDbl(aryTemp(1)))
                Call SetStdCalKit_Data(StdCKit, Unit_LoadL, CDbl(aryTemp(2)))
                Call SetStdCalKit_Data(StdCKit, Unit_LoadC, CDbl(aryTemp(3)))
            Else
                .loRs = CDbl(aryTemp(1))
                .loLs = CDbl(aryTemp(2))
                .loCp = CDbl(aryTemp(3))
            End If
        End With
    End If
    
    'Part Sweep Title
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    'Part Sweep Setting
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
    PartSweep(BdId, ActCh(BdId)) = int_sw
    frmMain.Check_prt.Value = int_sw
    frmMain.Text_trg(0).Text = CStr(aryTemp(2))
    frmMain.Text_trg(1).Text = CStr(aryTemp(3))
 
    'Sweep Time (ms)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    SwpTime = CDbl(aryTemp(1))
    If aryTemp(2) = "AUTO" Then
        SwpTAt = 1
    Else
        SwpTAt = 0
    End If
 
    ' Number of Freq.Segment
    MinFreq = 0: MaxFreq = 0
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    SegCnt = CInt(aryTemp(1))
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    For i = 0 To SegCnt - 1
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        With BufSeg(i)
            .dblFreq1 = CDbl(aryTemp(1)) * Unit_mega
            .dblFreq2 = CDbl(aryTemp(2)) * Unit_mega
            If .dblFreq1 > .dblFreq2 And CDbl(cnt_CSV_WRITE_VER100) >= CDbl(strCsvVer) Then
                .dblFreq2 = .dblFreq1 + .dblFreq2
            End If
            .lngPntN = CLng(aryTemp(3))
            .lngFmode = BIS_FREQ_LIN
            .lngFtype = BIS_FREQ_STRSTP
            .sngPow1 = CDbl(aryTemp(4))
            .sngPow2 = CDbl(aryTemp(5))
            If aryTemp(4) = aryTemp(5) Then
                frmMain.Check_pw2.Value = 0
            Else
                frmMain.Check_pw2.Value = 1
            End If
            .sngRbw = CLng(CDbl(aryTemp(6)) * Unit_k)
            .sngStime = CDbl(aryTemp(7)) * Unit_m
            
            If MinFreq = 0 Then MinFreq = .dblFreq1
            If .dblFreq1 <= .dblFreq2 Then
                If .dblFreq1 < MinFreq Then MinFreq = .dblFreq1
                If MaxFreq < .dblFreq2 Then MaxFreq = .dblFreq2
            Else
                If .dblFreq2 < MinFreq Then MinFreq = .dblFreq2
                If MaxFreq < .dblFreq1 Then MaxFreq = .dblFreq1
            End If
        End With
    Next i

    'Marker Title
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    'All Marker Display (ON/OFF)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
    frmMain.Check_mkr.Value = int_sw
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(2)), int_sw)
    frmMain.Check_MkrList.Value = int_sw    'Marker list (ON/OFF)
    ActMkr = CInt(aryTemp(3)) - 1           'Active marker number
    ChMkrInf(BdId, ActCh(BdId)).MkrActive = ActMkr
    ChMkrInf(BdId, ActCh(BdId)).MkrMinFreq = MinFreq
    ChMkrInf(BdId, ActCh(BdId)).MkrMaxFreq = MaxFreq
    RdActMkr = ActMkr
    For i = 0 To frmMain.Combo_MkrActFormat.ListCount
        If frmMain.Combo_MkrActFormat.List(i) = CStr(aryTemp(4)) Then
            RdOverlapMkrFormat = i
            Exit For
        End If
    Next i
    
    If CDbl(cnt_CSV_WRITE_VER300) <= CDbl(strCsvVer) Then
        Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(5)), int_sw)
        frmMain.Check_Compensate.Value = int_sw
        CmpsInf(BdId, ActCh(BdId)).CmpsFlag = CInt(aryTemp(6))
        CmpsInf(BdId, ActCh(BdId)).CmpsZeroSpn = CInt(aryTemp(7))
    End If
    
    'Marker Number
    ChMkrInf(BdId, ActCh(BdId)).MkrTotalcnt = 0
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    RdDispMarkerMax = 0
    For i = 0 To MAX_MARKER
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        With Marker(BdId, ActCh(BdId), i)
            Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
            .MkrDispFlag = int_sw
            If int_sw Then ChMkrInf(BdId, ActCh(BdId)).MkrTotalcnt = ChMkrInf(BdId, ActCh(BdId)).MkrTotalcnt + 1: RdDispMarkerMax = i
            .MkrFreq = CDbl(aryTemp(2))
            If .MkrFreq < MinFreq Then .MkrFreq = MinFreq
            If MaxFreq < .MkrFreq Then .MkrFreq = MaxFreq
            .MkrPoint = CInt(aryTemp(3)) - 1
            If MaxFreq - MinFreq <> 0 Then
                .MkrDispPosi = (.MkrFreq - MinFreq) / ((MaxFreq - MinFreq) / 100)
            Else
                .MkrDispPosi = 0
            End If
        End With
    Next i

    'Measurement
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    For i = 0 To frmMain.Option_msr.UBound
        If frmMain.Option_msr(i).Caption = CStr(aryTemp(1)) Then
            frmMain.Option_msr(i).Value = True
            Exit For
        End If
    Next i
    If i = McrMeas_AR Then
        RdMeas = BIS_MEAS_AR
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeas__A Then
        RdMeas = BIS_MEAS_A
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeas__R Then
        RdMeas = BIS_MEAS_R
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeasS21 Then
        RdMeas = BIS_MEAS_S21
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeasS11 Then
        RdMeas = BIS_MEAS_S11
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeasS12 Then
        RdMeas = BIS_MEAS_S21
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeasS22 Then
        RdMeas = BIS_MEAS_S11
        DPDTPort(BdId, ActCh(BdId)) = i
    End If

    'Active Format(LogMag/POLAR/Smith/DELAY/SWR/REAL/IMAG/Overlap)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    RdDispFromatTab = FmtTypeLogMg
    strTmp = CStr(aryTemp(1))
    If strTmp = "LogMag" Then
        RdDispFromatTab = FmtTypeLogMg
    ElseIf strTmp = "POLAR" Then
        RdDispFromatTab = FmtTypePolar
    ElseIf strTmp = "Smith" Then
        RdDispFromatTab = FmtTypeSmith
    ElseIf strTmp = "DELAY" Then
        RdDispFromatTab = FmtTypeDelay
    ElseIf strTmp = "SWR" Then
        RdDispFromatTab = FmtTypeSwr
    ElseIf strTmp = "REAL" Then
        RdDispFromatTab = FmtTypeReal
    ElseIf strTmp = "IMAG" Then
        RdDispFromatTab = FmtTypeImag
    ElseIf strTmp = "Overlap" Then
        RdDispFromatTab = FmtTypeOverlap
    End If
    
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
    frmMain.Check_phs.Value = int_sw        'Phase (ON/OFF)
    
    'Measurement Format
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    'Max Point
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    MaxPLogmag = CInt(aryTemp(1)) - 1
    MaxPDelay = CInt(aryTemp(2)) - 1
    MaxPSwr = CInt(aryTemp(3)) - 1
    'Min Point
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    MinPLogmag = CInt(aryTemp(1)) - 1
    MinPDelay = CInt(aryTemp(2)) - 1
    MinPSwr = CInt(aryTemp(3)) - 1
    '0deg Point
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    DegPLogmag = CInt(aryTemp(1)) - 1

    'Information on format
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    'LOGMAG Scale (/DIV, Rev Val, Ref Posi)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Mscl(BdId, ActCh(BdId)).div = CSng(aryTemp(1))
    Mscl(BdId, ActCh(BdId)).ref = CSng(aryTemp(2))
    Mscl(BdId, ActCh(BdId)).pos = CSng(aryTemp(3))
    
    'PHASE Scale (/DIV, Rev Val, Ref Posi)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Pscl(BdId, ActCh(BdId)).div = CSng(aryTemp(1))
    Pscl(BdId, ActCh(BdId)).ref = CSng(aryTemp(2))
    Pscl(BdId, ActCh(BdId)).pos = CSng(aryTemp(3))
    
    'DELAY Scale (/DIV, Rev Val, Ref Posi)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Dscl(BdId, ActCh(BdId)).div = CSng(aryTemp(1))
    Dscl(BdId, ActCh(BdId)).ref = CSng(aryTemp(2))
    Dscl(BdId, ActCh(BdId)).pos = CSng(aryTemp(3))
    
    'SWR Scale (/DIV, Rev Val, Ref Posi)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    SWRscl(BdId, ActCh(BdId)).div = CSng(aryTemp(1))
    SWRscl(BdId, ActCh(BdId)).ref = CSng(aryTemp(2))
    SWRscl(BdId, ActCh(BdId)).pos = CSng(aryTemp(3))

    'Overlap Format Title
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    'Overlap ON/OFF
    lcnt = RdWtMeasData(fileno, lcnt, aryOverlap, s, cnt_READ)

    'Measured Sweep Time
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    frmMain.Text_tim.Text = CStr(aryTemp(1))         'Sweep Time

    'Number of Trace Points
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    totalP = CInt(aryTemp(1))
    'Measurement Number
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    For i = 0 To totalP - 1
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        If aryTemp(1) <> "" Then BufFrq(i) = CDbl(aryTemp(1))
        If aryTemp(2) <> "" Then BufLgm(i) = CSng(aryTemp(2)):
        If aryTemp(3) <> "" Then BufPhs(i) = CSng(aryTemp(3)): If aryTemp(2) <> "" Then RdSavedDtType = RD_LOGMAG_DATA
        If aryTemp(4) <> "" Then BufLnm(i) = CSng(aryTemp(4)):
        If aryTemp(5) <> "" Then BufReal(i) = CSng(aryTemp(5))
        If aryTemp(6) <> "" Then
            BufImag(i) = CSng(aryTemp(6))
            If aryTemp(5) <> "" Then
                RdSavedDtType = RdSavedDtType Or RD_POLAR__DATA Or RD_SMITH__DATA Or RD_REAL___DATA Or RD_IMAG___DATA
            End If
        End If
        If aryTemp(7) <> "" Then BufDelay(i) = CSng(aryTemp(7)): RdSavedDtType = RdSavedDtType Or RD_DELAY__DATA
        If aryTemp(8) <> "" Then BufSwr(i) = CSng(aryTemp(8)): RdSavedDtType = RdSavedDtType Or RD_SWR____DATA
    Next i
    
    'Overlap Format Title
    If CDbl(cnt_CSV_WRITE_VER220) >= CDbl(strCsvVer) Then
        n = 4
    Else
        n = frmMain.Check_Format.UBound
    End If
    For i = 0 To n
        Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryOverlap(i + 1)), int_sw)
        frmMain.Check_Format(i).Value = int_sw
    Next i
    
    If CDbl(cnt_CSV_WRITE_VER300) <= CDbl(strCsvVer) Then
        MemTrcDispInf(BdId, ActCh(BdId)).MemTrcActive = 0
        MemTrcDispInf(BdId, ActCh(BdId)).MemTrcTotalDispFlag = 0
        For i = 0 To MAX_MEMTRACE
            MemTrcDispInf(BdId, ActCh(BdId)).MemTrcSaveFlag(i) = MTRC_NOT_SAVE
            MemTrcDispInf(BdId, ActCh(BdId)).MemTrcDispFlag(i) = MEM_TRC_DSP_OFF
        Next i

        'Numerical of Memory Trace
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        tr = CInt(aryTemp(1))
        ActMemTrc = CInt(aryTemp(2)) - 1
        MemTrcDispInf(BdId, ActCh(BdId)).MemTrcActive = ActMemTrc
        If tr <> 0 Then
            For tr = 0 To tr - 1
                'Memory Trace Number
                lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
                n = CInt(aryTemp(1)) - 1
                
                'Memory Trace Display
                lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
                Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
                MemTrcDispInf(BdId, ActCh(BdId)).MemTrcDispFlag(n) = int_sw
                If int_sw Then MemTrcDispInf(BdId, ActCh(BdId)).MemTrcTotalDispFlag = MemTrcDispInf(BdId, ActCh(BdId)).MemTrcTotalDispFlag + MEM_TRC_DSP_ON
                MemTrcDispInf(BdId, ActCh(BdId)).MemTrcSaveFlag(n) = MTRC_SAVE
                
                'Number of Trace Points
                lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
                
                'Memory Measurement Number
                lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
                
                RdSavedDtType = RD_LOGMAG_DATA Or RD_POLAR__DATA Or RD_SMITH__DATA Or RD_REAL___DATA Or RD_IMAG___DATA Or RD_DELAY__DATA Or RD_SWR____DATA
                With ChMemTrcInf(BdId, ActCh(BdId), n)
                    For i = 0 To totalP - 1
                        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
                        .MemTrcBufLgm(i) = CSng(aryTemp(2))
                        .MemTrcBufPhs(i) = CSng(aryTemp(3))
                        .MemTrcBufLnm(i) = CSng(aryTemp(4))
                        .MemTrcBufReal(i) = CSng(aryTemp(5))
                        .MemTrcBufImag(i) = CSng(aryTemp(6))
                        .MemTrcBufDelay(i) = CSng(aryTemp(7))
                        .MemTrcBufSwr(i) = CSng(aryTemp(8))
                    Next i
                End With
            Next tr
        End If
    End If

    ReadMeasData = False
    
ErrEnd:
    On Error GoTo 0 '*** ON ERROR reset ****
    Exit Function

ErrReadFile:
    MsgBox fn & "Error line[ " & CLng(lcnt) & " ]: " + vbCrLf + vbCrLf + CStr(aryTemp(0)), vbOKOnly Or vbCritical
ErrProductType:
    GoTo ErrEnd

End Function
'
Private Sub ReadCalFile(fn As String)
    Dim fileno As Long
    Dim i As Integer

    fn = Mid(fn, 1, Len(fn) - 3)
    fn = fn & "bin"
    On Error GoTo svferr
    
    fileno = FreeFile
    '
    Open fn For Binary Access Read As #fileno Len = Len(cal1(0))
        For i = 0 To totalP - 1
            Get #fileno, , cal1(i * 2)
            Get #fileno, , cal1(i * 2 + 1)
            Get #fileno, , cal2(i * 2)
            Get #fileno, , cal2(i * 2 + 1)
            Get #fileno, , cal3(i * 2)
            Get #fileno, , cal3(i * 2 + 1)
        Next i
    Close #fileno
    On Error GoTo 0
    Exit Sub

svferr:
    MsgBox "Error:" & str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    Close #fileno
    On Error GoTo 0
End Sub

'
'The setting condition data is read from the CSV file.
'
Public Function ReadCsvFile(fn As String) As Boolean
    Dim FileNum As Long
    Dim blnRtn As Boolean
    Dim fn_cal As String
    
    ReadCsvFile = False
    FileNum = FreeFile
    Open fn For Input As #FileNum
        blnRtn = ReadMeasData(fn, FileNum)
    Close #FileNum
    If blnRtn = False Then  'ReadMeasData() -> False is a normal termination
        If RdCorOn And frmMain.Cmd_connect.Enabled = False Then ' Calibration ON and Connect BNA
            fn_cal = Mid(fn, 1, Len(fn) - 3)
            fn_cal = fn_cal & "bin"
            If FileDlg.FileExists(fn_cal) = True Then
                Call ReadCalFile(fn_cal)    'Read Calibration file
            Else
                frmMain.Text_hd(0).Text = ""
                CorOn = 0
                RdCorOn = 0 ' Calibration OFF
                MsgBox "Error: Calibration file is not found " & fn_cal, vbOKOnly Or vbCritical
            End If
        Else
            frmMain.Text_hd(0).Text = ""
            CorOn = 0
        End If
        
    End If
    ReadCsvFile = blnRtn
End Function

Public Function SaveNormal(ByRef fn As String, ByRef fileno As Long, ByRef lcnt As Long, ByRef s As String) As Boolean
    Dim strTemp As Variant
    Dim i As Integer
    Dim str_sw As String
    Dim act_format As Integer
    Dim view_wave As Integer
    Dim plog_max As Long
    Dim plog_min As Long
    Dim p0deg As Long
    Dim pdel_max As Long
    Dim pdel_min As Long
    Dim pswr_max As Long
    Dim pswr_min As Long
    Dim dblFreq As Double
    Dim sta As Double
    Dim sto As Double
    Dim tr As Integer

    SaveNormal = True
    
    On Error GoTo ErrSaveNormal
    
    ' Number of Freq.Segment
    strTemp = cnt_FRQ_SEGM_TITLE & s & CStr(SegCnt)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    strTemp = cnt_SEG_NO___TITLE & s & cnt_FRQ_STAR_TITLE & s & cnt_FRQ_STOP_TITLE & s & cnt_FRQ_POIN_TITLE & s & _
            cnt_FRQ_STPW_TITLE & s & cnt_FRQ_SPPW_TITLE & s & cnt_FRQ_RBW__TITLE & s & cnt_FRQ_STTM_TITLE
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
            
    For i = 0 To SegCnt - 1
        With BufSeg(i)
            sta = .dblFreq1: sto = .dblFreq2
            If BufSeg(i).lngFtype Then sta = sta - (sto / 2): sto = sta + sto ' Converts cen/spa to sta/sto.
            If frmMain.Check_pw2.Value = 1 Then
                strTemp = CStr(i + 1) & s & Format(dblRound(sta, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR) _
                    & s & Format(dblRound(sto, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR) & _
                s & CStr(.lngPntN) & s & Format(.sngPow1, cnt_LEVL_TO_STR) & s & Format(.sngPow2, cnt_LEVL_TO_STR) & s & _
                Format(dblRound(.sngRbw, Unit_k, cnt_RBW_ADJUST), cnt_RBW_TO_STR) & s & _
                Format(dblRound(.sngStime, Unit_m, cnt_STTM_ADJUST), cnt_STTM_TO_STR)
            Else
                strTemp = CStr(i + 1) & s & Format(dblRound(sta, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR) _
                    & s & Format(dblRound(sto, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR) & _
                s & CStr(.lngPntN) & s & Format(.sngPow1, cnt_LEVL_TO_STR) & s & Format(.sngPow1, cnt_LEVL_TO_STR) & s & _
                Format(dblRound(.sngRbw, Unit_k, cnt_RBW_ADJUST), cnt_RBW_TO_STR) & s & _
                Format(dblRound(.sngStime, Unit_m, cnt_STTM_ADJUST), cnt_STTM_TO_STR)
            End If
        End With
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    Next i
    
    'Marker Title
    strTemp = cnt_MARKER___TITLE & s & cnt_ALL_MKR__TITLE & s & cnt_MKR_LIST_TITLE & s & cnt_ACT_MKR__TITLE _
                & s & cnt_MKR_OVRL_TITLE & s & cnt_MKR_CMPS_TITLE & s & cnt_MKR_CMPL_TITLE & s & cnt_MKR_CMPZ_TITLE
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    'All Marker Display (ON/OFF)
    Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmMain.Check_mkr.Value)
    strTemp = cnt_MARKER_I_TITLE & s & str_sw
    Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmMain.Check_MkrList.Value)        'All Marker Display (ON/OFF)
    strTemp = strTemp & s & str_sw & s & CStr(ActMkr + 1)                       'Active marker number
    strTemp = strTemp & s & frmMain.Combo_MkrActFormat.List(frmMain.Combo_MkrActFormat.ListIndex)
'*** CSV Rev.3.000 ->> ***
    Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmMain.Check_Compensate.Value)
    strTemp = strTemp & s & str_sw
    strTemp = strTemp & s & CmpsInf(BdId, ActCh(BdId)).CmpsFlag
    strTemp = strTemp & s & CmpsInf(BdId, ActCh(BdId)).CmpsZeroSpn
'*** <<- CSV Rev.3.000 ***
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    'Marker Number
    strTemp = cnt_MKR_NUMB_TITLE & s & cnt_MKR_NUMB_TITLE & s & cnt_MKR_FREQ_TITLE & s & cnt_MKR_POIN_TITLE
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    For i = 0 To MAX_MARKER
        With Marker(BdId, ActCh(BdId), i)
            Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, .MkrDispFlag)
            strTemp = CStr(i + 1) & s & str_sw & s & Format(Marker(BdId, ActCh(BdId), i).MkrFreq, cnt_FREQ_TO_STR) & s & CStr(.MkrPoint + 1)

        End With
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    Next i

    'Measurement
    strTemp = cnt_MEAS_____TITLE
    For i = 0 To frmMain.Option_msr.UBound
        If frmMain.Option_msr(i).Value = True Then
            strTemp = strTemp & s & frmMain.Option_msr(i).Caption
            Exit For
        End If
    Next i
    If i = McrMeas_AR Then
        RdMeas = BIS_MEAS_AR
    ElseIf i = McrMeas__A Then
        RdMeas = BIS_MEAS_A
    ElseIf i = McrMeas__R Then
        RdMeas = BIS_MEAS_R
    ElseIf i = McrMeasS21 Then
        RdMeas = BIS_MEAS_S21
    ElseIf i = McrMeasS11 Then
        RdMeas = BIS_MEAS_S11
    ElseIf i = McrMeasS12 Then
        RdMeas = BIS_MEAS_S21
    ElseIf i = McrMeasS22 Then
        RdMeas = BIS_MEAS_S11
    End If
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    tr = 0
    For i = 0 To MAX_MEMTRACE
        If MemTrcDispInf(BdId, ActCh(BdId)).MemTrcSaveFlag(i) = MTRC_SAVE Then
            tr = tr + 1
        End If
    Next i

    'Active Format(LogMag/POLAR/Smith/DELAY/SWR/REAL/IMAG/Overlap)
    strTemp = cnt_ACT_FORM_TITLE
    act_format = frmMain.SSTab_DispFromat.Tab

    If tr <> 0 Then

        view_wave = INI_FILE_RW_OVRLAP_LOGMAG
        view_wave = view_wave Or INI_FILE_RW_OVRLAP__POLAR
        view_wave = view_wave Or INI_FILE_RW_OVRLAP__SMITH
        view_wave = view_wave Or INI_FILE_RW_OVRLAP__DELAY
        view_wave = view_wave Or INI_FILE_RW_OVRLAP____SWR
        view_wave = view_wave Or INI_FILE_RW_OVRLAP___REAL
        view_wave = view_wave Or INI_FILE_RW_OVRLAP___IMAG

        If act_format = FmtTypeLogMg Then
            strTemp = strTemp & s & "LogMag"
        ElseIf act_format = FmtTypePolar Then
            strTemp = strTemp & s & "POLAR"
        ElseIf act_format = FmtTypeSmith Then
            strTemp = strTemp & s & "Smith"
        ElseIf act_format = FmtTypeDelay Then
            strTemp = strTemp & s & "DELAY"
        ElseIf act_format = FmtTypeSwr Then
            strTemp = strTemp & s & "SWR"
        ElseIf act_format = FmtTypeReal Then
            strTemp = strTemp & s & "REAL"
        ElseIf act_format = FmtTypeImag Then
            strTemp = strTemp & s & "IMAG"
        ElseIf act_format = FmtTypeOverlap Then
            strTemp = strTemp & s & "Overlap"
        Else
            If frmMain.Check_phs.Value Then
                strTemp = strTemp & s & "LogMag & Phase"
            Else
                strTemp = strTemp & s & "LogMag"
            End If
        End If
    Else
        view_wave = INI_FILE_RW_OVRLAP_NOT_DISP

        If act_format = FmtTypeLogMg Then
            view_wave = INI_FILE_RW_OVRLAP_LOGMAG
            strTemp = strTemp & s & "LogMag"
        ElseIf act_format = FmtTypePolar Then
            view_wave = INI_FILE_RW_OVRLAP__POLAR
            strTemp = strTemp & s & "POLAR"
        ElseIf act_format = FmtTypeSmith Then
            view_wave = INI_FILE_RW_OVRLAP__SMITH
            strTemp = strTemp & s & "Smith"
        ElseIf act_format = FmtTypeDelay Then
            view_wave = INI_FILE_RW_OVRLAP__DELAY
            strTemp = strTemp & s & "DELAY"
        ElseIf act_format = FmtTypeSwr Then
            view_wave = INI_FILE_RW_OVRLAP____SWR
            strTemp = strTemp & s & "SWR"
        ElseIf act_format = FmtTypeReal Then
            view_wave = INI_FILE_RW_OVRLAP___REAL
            strTemp = strTemp & s & "REAL"
        ElseIf act_format = FmtTypeImag Then
            view_wave = INI_FILE_RW_OVRLAP___IMAG
            strTemp = strTemp & s & "IMAG"
        ElseIf act_format = FmtTypeOverlap Then
            If frmMain.Check_Format(ChkTypeLogMg).Value = 1 Then view_wave = INI_FILE_RW_OVRLAP_LOGMAG
            If frmMain.Check_Format(ChkTypePolar).Value = 1 Then view_wave = view_wave Or INI_FILE_RW_OVRLAP__POLAR
            If frmMain.Check_Format(ChkTypeSmith).Value = 1 Then view_wave = view_wave Or INI_FILE_RW_OVRLAP__SMITH
            If frmMain.Check_Format(ChkTypeDelay).Value = 1 Then view_wave = view_wave Or INI_FILE_RW_OVRLAP__DELAY
            If frmMain.Check_Format(ChkTypeSwr).Value = 1 Then view_wave = view_wave Or INI_FILE_RW_OVRLAP____SWR
            If frmMain.Check_Format(ChkTypeReal).Value = 1 Then view_wave = view_wave Or INI_FILE_RW_OVRLAP___REAL
            If frmMain.Check_Format(ChkTypeImag).Value = 1 Then view_wave = view_wave Or INI_FILE_RW_OVRLAP___IMAG
            strTemp = strTemp & s & "Overlap"
        Else
            act_format = FmtTypeLogMg
            If frmMain.Check_phs.Value Then
                strTemp = strTemp & s & "LogMag & Phase"
            Else
                strTemp = strTemp & s & "LogMag"
            End If
        End If
    End If

    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmMain.Check_phs.Value)
    strTemp = cnt_PHS_DISP_TITLE & s & str_sw
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    'Measurement Format
    strTemp = cnt_MEAS_FMT_TITLE & s & cnt_FMT_OLOG_TITLE & s & cnt_FMT_ODEL_TITLE & s & cnt_FMT_OSWR_TITLE
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    plog_max = -1: plog_min = -1: pdel_max = -1: pdel_min = -1: pswr_max = -1: pswr_min = -1: p0deg = -1
    plog_max = lngSearchData(MEAS_MAX_ID, FmtTypeLogMg, dblFreq)
    plog_min = lngSearchData(MEAS_MIN_ID, FmtTypeLogMg, dblFreq)
    If frmMain.Check_phs.Value Then p0deg = lngSearchData(MEAS_0DG_ID, FmtTypeLogMg, dblFreq)    'Phase
    If (view_wave And INI_FILE_RW_OVRLAP__DELAY) = INI_FILE_RW_OVRLAP__DELAY Then           'DELAY
        pdel_max = lngSearchData(MEAS_MAX_ID, FmtTypeDelay, dblFreq)
        pdel_min = lngSearchData(MEAS_MIN_ID, FmtTypeDelay, dblFreq)
    End If
    If (view_wave And INI_FILE_RW_OVRLAP____SWR) = INI_FILE_RW_OVRLAP____SWR Then           'SWR
        pswr_max = lngSearchData(MEAS_MAX_ID, FmtTypeSwr, dblFreq)
        pswr_min = lngSearchData(MEAS_MIN_ID, FmtTypeSwr, dblFreq)
    End If

    'Max Point
    strTemp = cnt_MEAS_MAX_TITLE & s & CStr(plog_max + 1) & s & CStr(pdel_max + 1) & s & CStr(pswr_max + 1)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    'Min Point
    strTemp = cnt_MEAS_MIN_TITLE & s & CStr(plog_min + 1) & s & CStr(pdel_min + 1) & s & CStr(pswr_min + 1)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    '0deg Point
    strTemp = cnt_MEAS_0DG_TITLE & s & CStr(p0deg + 1)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    'Information on format
    strTemp = cnt_FMT_INF__TITLE & s & cnt_FMT_DIV__TITLE & s & cnt_FMT_REFV_TITLE & s & cnt_FMT_REFP_TITLE
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    'LOGMAG Scale (/DIV, Rev Val, Ref Posi)
    strTemp = cnt_FMT_LGM__TITLE & s & CStr(Mscl(BdId, ActCh(BdId)).div) & s & CStr(Mscl(BdId, ActCh(BdId)).ref) & s & CStr(Mscl(BdId, ActCh(BdId)).pos)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    'PHASE Scale (/DIV, Rev Val, Ref Posi)
    strTemp = cnt_FMT_PHS__TITLE & s & CStr(Pscl(BdId, ActCh(BdId)).div) & s & CStr(Pscl(BdId, ActCh(BdId)).ref) & s & CStr(Pscl(BdId, ActCh(BdId)).pos)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    'DELAY Scale (/DIV, Rev Val, Ref Posi)
    strTemp = cnt_FMT_DEL__TITLE & s & CStr(Dscl(BdId, ActCh(BdId)).div) & s & CStr(Dscl(BdId, ActCh(BdId)).ref) & s & CStr(Dscl(BdId, ActCh(BdId)).pos)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    'SWR Scale (/DIV, Rev Val, Ref Posi)
    strTemp = cnt_FMT_SWR__TITLE & s & CStr(SWRscl(BdId, ActCh(BdId)).div) & s & CStr(SWRscl(BdId, ActCh(BdId)).ref) & s & CStr(SWRscl(BdId, ActCh(BdId)).pos)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    'Overlap Format Title
    strTemp = cnt_FMT_OVR__TITLE & s & cnt_FMT_OLOG_TITLE & s & cnt_FMT_OPOL_TITLE & s & cnt_FMT_OSMI_TITLE & s & _
                cnt_FMT_ODEL_TITLE & s & cnt_FMT_OSWR_TITLE
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    'Overlap ON/OFF
    strTemp = cnt_FMT_OVRS_TITLE
    For i = 0 To frmMain.Check_Format.UBound
        Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmMain.Check_Format(i).Value)
        strTemp = strTemp & s & str_sw
    Next i
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    'Measured Sweep Time
    strTemp = cnt_TRC_TIME_TITLE & s & frmMain.Text_tim.Text
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    'Number of Trace Points
    strTemp = cnt_TRC_POIN_TITLE & s & CStr(totalP)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    'Measurement Number
    strTemp = cnt_TRC_NO___TITLE & s & cnt_FMT_MEAS_FREQ & s & cnt_FMT_MEAS_LOGM & s & cnt_FMT_MEAS_PHAS & s & _
                cnt_FMT_MEAS_LINM & s & cnt_FMT_MEAS_REAL & s & cnt_FMT_MEAS_IMAG & s & _
                   cnt_FMT_MEAS_DELA & s & cnt_FMT_MEAS__SWR
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    For i = 0 To totalP - 1
        strTemp = CStr(i + 1) & s & Format(BufFrq(i), cnt_FREQ_TO_STR)
        strTemp = strTemp & s & Format(BufLgm(i), cnt_LEVL_TO_STR)   'Logmag
        strTemp = strTemp & s & Format(BufPhs(i), cnt_LEVL_TO_STR)   'Phase
        strTemp = strTemp & s & Format(BufLnm(i), cnt_LEVL_TO_STR)   'Linmag
        strTemp = strTemp & s & Format(BufReal(i), cnt_LEVL_TO_STR)  'Real
        strTemp = strTemp & s & Format(BufImag(i), cnt_LEVL_TO_STR)  'Imag
        strTemp = strTemp & s & Format(BufDelay(i), cnt_LEVL_TO_STR) 'DELAY
        strTemp = strTemp & s & Format(BufSwr(i), cnt_LEVL_TO_STR)   'SWR
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    Next i

'*** CSV Rev.3.000 ->> ***
    'Numerical of Memory Trace
    strTemp = cnt_MEM_TR_NUM_TT & s & CStr(tr) & s & CStr(ActMemTrc + 1)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    If tr <> 0 Then
        For tr = 0 To MAX_MEMTRACE
            If MemTrcDispInf(BdId, ActCh(BdId)).MemTrcSaveFlag(tr) = MTRC_SAVE Then

                'Memory Trace Number
                strTemp = cnt_MEM_TRC_NO_TT & s & CStr(tr + 1)
                lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

                'Memory Trace Display
                Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, MemTrcDispInf(BdId, ActCh(BdId)).MemTrcDispFlag(tr))
                strTemp = cnt_MEM_TRC_DSPTT & s & str_sw
                lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

                'Number of Trace Points
                strTemp = cnt_TRC_POIN_TITLE & s & CStr(totalP)
                lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

                'Memory Measurement Number
                strTemp = cnt_MEM_MES_NO_TT & s & cnt_FMT_MEAS_FREQ & s & cnt_FMT_MEAS_LOGM & s & cnt_FMT_MEAS_PHAS & s & _
                            cnt_FMT_MEAS_LINM & s & cnt_FMT_MEAS_REAL & s & cnt_FMT_MEAS_IMAG & s & _
                               cnt_FMT_MEAS_DELA & s & cnt_FMT_MEAS__SWR
                lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

                With ChMemTrcInf(BdId, ActCh(BdId), tr)
                    For i = 0 To totalP - 1
                        strTemp = CStr(i + 1) & s & Format(BufFrq(i), cnt_FREQ_TO_STR)
                        strTemp = strTemp & s & Format(.MemTrcBufLgm(i), cnt_LEVL_TO_STR)   'Logmag
                        strTemp = strTemp & s & Format(.MemTrcBufPhs(i), cnt_LEVL_TO_STR)   'Phase
                        strTemp = strTemp & s & Format(.MemTrcBufLnm(i), cnt_LEVL_TO_STR)   'Linmag
                        strTemp = strTemp & s & Format(.MemTrcBufReal(i), cnt_LEVL_TO_STR)  'Real
                        strTemp = strTemp & s & Format(.MemTrcBufImag(i), cnt_LEVL_TO_STR)  'Imag
                        strTemp = strTemp & s & Format(.MemTrcBufDelay(i), cnt_LEVL_TO_STR) 'DELAY
                        strTemp = strTemp & s & Format(.MemTrcBufSwr(i), cnt_LEVL_TO_STR)   'SWR
                        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
                    Next i
                End With
            End If
        Next tr
    End If

    SaveNormal = False
    On Error GoTo 0
    Exit Function

ErrSaveNormal:
    Close #fileno
    MsgBox fn & "Error:" & str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    On Error GoTo 0

End Function

Public Function SaveXtal(ByRef fn As String, ByRef fileno As Long, ByRef lcnt As Long, ByRef s As String) As Boolean
    Dim str_sw As String
    Dim strTemp As Variant
    Dim i As Integer
    
    SaveXtal = True
    
    On Error GoTo ErrSaveXtal
    
    'Measurement item Title
    strTemp = cnt_XTL_ITEM_TITLE & s & cnt_XTL_FR___TITLE & s & cnt_XTL_EQU__TITLE & s & cnt_XTL_FL___TITLE
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    'Measurement item Setting
    Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmEquMeas.Check_EquMeasItem(0).Value)
    strTemp = cnt_XTL_MEAS_TITLE & s & str_sw
    Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmEquMeas.Check_EquMeasItem(1).Value)
    strTemp = strTemp & s & str_sw
    Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmEquMeas.Check_EquMeasItem(2).Value)
    strTemp = strTemp & s & str_sw
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    'Result Limit Title
    strTemp = cnt_XTL_LMT__TITLE & s & cnt_XTL_LMT_C0_TTL & s & cnt_XTL_LMT_C1_TTL & s & cnt_XTL_LMT_L1_TTL
    strTemp = strTemp & s & cnt_XTL_LMT_R1_TTL & s & cnt_XTL_LMT_Q__TTL & s & cnt_XTL_LMT_Fr_TTL & s & cnt_XTL_LMT_CI_TTL
    strTemp = strTemp & s & cnt_XTL_LMT_FL_TTL
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    'Upper Limit
    strTemp = cnt_XTL_LMTU_TITLE
    For i = LMT_C0_Index To LMT_FL_Index
        strTemp = strTemp & s & frmEquMeas.Text_UpLimit(i).Text
    Next i
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    'Lower Limit
    strTemp = cnt_XTL_LMTL_TITLE
    For i = LMT_C0_Index To LMT_FL_Index
        strTemp = strTemp & s & frmEquMeas.Text_LwLimit(i).Text
    Next i
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    ' Number of Freq.Segment
    strTemp = cnt_FRQ_SEGM_TITLE & s & CStr(MAX_XTAL_MEAS + 1)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    strTemp = cnt_SEG_NO___TITLE & s & cnt_XTAL_CFREQ & s & cnt_XTAL_SPAN & s & cnt_FRQ_POIN_TITLE & s & _
            cnt_FRQ_STPW_TITLE & s & cnt_FRQ_SPPW_TITLE & s & cnt_FRQ_RBW__TITLE & s & cnt_FRQ_STTM_TITLE
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
            
    For i = 0 To MAX_XTAL_MEAS
        With XtalBufSeg(i)
            If .dblFreq2 <> .dblFreq1 Then
                strTemp = CStr(i + 1) & s & Format(dblRound(.dblFreq1, Unit_k, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR) _
                    & s & Format(.dblFreq2 / .dblFreq1 * Unit_mega, "#0.0#") & _
                s & CStr(.lngPntN) & s & Format(.sngPow1, cnt_LEVL_TO_STR) & s & Format(.sngPow1, cnt_LEVL_TO_STR) & s & _
                Format(dblRound(.sngRbw, Unit_k, cnt_RBW_ADJUST), cnt_RBW_TO_STR) & s & _
                Format(dblRound(.sngStime, Unit_m, cnt_STTM_ADJUST), cnt_STTM_TO_STR)
            Else
                strTemp = CStr(i + 1) & s & Format(dblRound(.dblFreq1, Unit_k, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR) _
                    & s & Format(.dblFreq2 - .dblFreq1, "#0.0#") & _
                s & CStr(.lngPntN) & s & Format(.sngPow1, cnt_LEVL_TO_STR) & s & Format(.sngPow1, cnt_LEVL_TO_STR) & s & _
                Format(dblRound(.sngRbw, Unit_k, cnt_RBW_ADJUST), cnt_RBW_TO_STR) & s & _
                Format(dblRound(.sngStime, Unit_m, cnt_STTM_ADJUST), cnt_STTM_TO_STR)
            End If
        End With
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    Next i
    
    'Measurement
    strTemp = cnt_MEAS_____TITLE
    For i = 0 To frmMain.Option_msr.UBound
        If frmMain.Option_msr(i).Value = True Then
            strTemp = strTemp & s & frmMain.Option_msr(i).Caption
            Exit For
        End If
    Next i
    If i = McrMeas_AR Then
        RdMeas = BIS_MEAS_AR
    ElseIf i = McrMeas__A Then
        RdMeas = BIS_MEAS_A
    ElseIf i = McrMeas__R Then
        RdMeas = BIS_MEAS_R
    ElseIf i = McrMeasS21 Then
        RdMeas = BIS_MEAS_S21
    ElseIf i = McrMeasS11 Then
        RdMeas = BIS_MEAS_S11
    ElseIf i = McrMeasS12 Then
        RdMeas = BIS_MEAS_S21
    ElseIf i = McrMeasS22 Then
        RdMeas = BIS_MEAS_S11
    End If
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    strTemp = "Device information"
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    strTemp = "f_nom [ ohm ]" & s & Format(dblRound(XtalMeas.dblNomFreq, Unit_s, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    strTemp = "Load capacitance [ e-12 ] H" & s & Format(XtalMeas.dblLoadCap * Multiple_p, "#####0.00")
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    strTemp = "Typ.CI [ e-15 ] F" & s & CStr(XtalMeas.dblTypicalCI)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    SaveXtal = False
    On Error GoTo 0
    Exit Function

ErrSaveXtal:
    Close #fileno
    MsgBox fn & "Error:" & str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    On Error GoTo 0

End Function

'
'   Save measurement data
'
Public Function SaveMeasData(ByRef fn As String, ByRef fileno As Long, ByRef AppName As String, ByRef RevNo As String) As Boolean
    Dim s As String
    Dim lcnt As Long
    Dim strTemp As Variant
    Dim str_sw As String
    Dim i As Integer
    Dim tmp As Long
    
    If FileDlg.FileExists(fn) = True Then
        On Error Resume Next
        Kill fn
        On Error GoTo 0
    End If
    '
    On Error GoTo ErrSaveFile
    
    SaveMeasData = False
    s = cnt_CSV_SEPA_CHAR
    
    lcnt = 0
    
    ' Application Name
    strTemp = cnt_APP_NAME_TITLE & s & AppName
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' CSV Sheet Revsion
    strTemp = cnt_CSV_SHET_TITLE & s & RevNo
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' Board Number
    strTemp = cnt_BD__NUMB_TITLE & s & frmMain.Combo_bd.ListIndex
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' IP Address
    strTemp = cnt_IP__ADDR_TITLE & s & frmMain.Text_con.Text
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' Product Name
    strTemp = cnt_PD__NAME_TITLE & s & NA_ProductName & s & NA_SerialNumber
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    ' Serial Number
    strTemp = cnt_PD_SERNO_TITLE & s & NA_SerialNumber
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' SW-BOX Type
    strTemp = cnt_SW_BOX___TITLE & s & strExpSwBoxType & s & CStr(SP4TPort(BdId, ActCh(BdId)) + 1)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' Channel Title
    strTemp = cnt_CH__NO___TITLE & s & "CH" & frmMain.Combo_ch.ListIndex + 1
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' Electrical length correction (ON/OFF)
    Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmMain.Check_EleCor.Value)
    strTemp = cnt_ELE__LEN_TITLE & s & str_sw
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' Electrical length correction (psec)
    strTemp = cnt_ELE__TIM_TITLE & s & frmMain.Text_Ele_Corr_Time.Text
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' Electrical length correction (mm) <--- Add Rev 2.100
    strTemp = cnt_ELE_LENG_TITLE & s & frmMain.Text_Ele_Corr_Length.Text
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
'*** CSV Rev.3.000 ->> ***
    ' Port Extension (ON/OFF)           <--- Add Rev 3.000
    Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmMain.Check_PortExt.Value)
    strTemp = cnt_PORT_EXT_TITLE & s & str_sw
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' Port Extension (psec)             <--- Add Rev 3.000
    strTemp = cnt_PORT_TIM_TITLE & s & frmMain.Text_PortExt_Time.Text
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' Port Extension (mm)               <--- Add Rev 3.000
    strTemp = cnt_PORT_LEN_TITLE & s & frmMain.Text_PortExt_Length.Text
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
'*** <<- CSV Rev.3.000 ***
    ' Port Impedance (ohm)
    strTemp = cnt_PORT_IMP_TITLE & s & frmMain.Text_z0.Text
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' Parameter conversion (OFF Z:TRAN Y:TRAN Z:REFL Y:REFL 1/S)
    strTemp = cnt_PARA_CNV_TITLE & s & frmMain.Combo_cnv.List(frmMain.Combo_cnv.ListIndex)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' Calibration Title
    strTemp = cnt_CAL______TITLE & s & cnt_CAL_INFO_TITLE & s & cnt_CAL_TIME_TITLE & s & _
                cnt_CAL1_STS_TITLE & s & cnt_CAL2_STS_TITLE & s & cnt_CAL3_STS_TITLE & s & cnt_CAL4_STS_TITLE
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' CAL status (ON/OFF)
     str_sw = "OFF"
    If CorOn <> 0 Then str_sw = "ON"
'    Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmMain.Check_cal.Value)
    strTemp = cnt_CAL_STAT_TITLE & s & str_sw & s & strGetCalDateTime & s & _
                CorAcq(0) & s & CorAcq(1) & s & CorAcq(2) & s & CorAcq(3)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' CAL status (Cor/C?/C!)
    strTemp = cnt_CAL_COR__TITLE & s
    If CorOn = 1 Then
        strTemp = strTemp & "Cor"
    ElseIf CorOn = 2 Then
        strTemp = strTemp & "C?"
    Else
        strTemp = strTemp & "C!"
    End If
'    strTemp = cnt_CAL_COR__TITLE & s & frmMain.Text_hd(0).Text
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' CAL Method (Norm/Trans/1 Port)
    strTemp = cnt_CAL_METH_TITLE & s
    If CorMeth = BIS_CAL_NORM Then
        strTemp = strTemp & "Norm"
    ElseIf CorMeth = BIS_CAL_TRANS Then
        strTemp = strTemp & "Trans"
    Else
        strTemp = strTemp & "1 Port"
    End If
'    strTemp = cnt_CAL_METH_TITLE & s & frmMain.Combo_cal.List(frmMain.Combo_cal.ListIndex)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' CAL Type (Don't@Care / User Define / 3.5mm / 3.5mm(R&S))
    strTemp = cnt_CAL_TYPE_TITLE & s & frmMain.Combo_CalKitType.List(frmMain.Combo_CalKitType.ListIndex)
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    ' User Cal Kit Connect Type (Female/Male)
    strTemp = cnt_CAL_SEXT_TITLE & s
    If frmMain.OptPortSexType(0).Value = True Then
        strTemp = strTemp & "Female"
    Else
        strTemp = strTemp & "Male"
    End If
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
   
    If 0 < InStr(NA_ProductName, PN_R3760__) Then
        'User Cal Kit OPEN Item Title
        strTemp = cnt_CALOITME_TITLE & s & cnt_OPEN_Z0__TITLE & s & cnt_OPEN_DEL_TITLE & s & cnt_OPEN_LOS_TITLE & s & _
                    cnt_OPEN_C0__TITLE & s & cnt_OPEN_C1__TITLE & s & cnt_OPEN_C2__TITLE & s & cnt_OPEN_C3__TITLE
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
       
        'OPEN Calibration data
        strTemp = cnt_CAL_OPEN_TITLE & s & frmMain.Text_CalKitParam(0).Text
        For i = 1 To 6
            strTemp = strTemp & s & frmMain.Text_CalKitParam(i).Text
        Next i
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
        'User Cal Kit SHORT Item Title
        strTemp = cnt_CALSITEM_TITLE & s & cnt_SHORT_Z0_TITLE & s & cnt_SHORT_DE_TITLE & s & cnt_SHORT_LO_TITLE & s & _
                cnt_SHORT_LO_TITLE & s & cnt_SHORT_L1_TITLE & s & cnt_SHORT_L2_TITLE & s & cnt_SHORT_L3_TITLE
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
        'SHORT Calibration data
        strTemp = cnt_CAL_SHOR_TITLE & s & frmMain.Text_CalKitParam(7).Text
        For i = 8 To 13
            strTemp = strTemp & s & frmMain.Text_CalKitParam(i).Text
        Next i
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
        'User Cal Kit LOAD Item Title
        strTemp = cnt_CALLITEM_TITLE & s & cnt_LOAD_Z0__TITLE & s & cnt_LOAD_DEL_TITLE & s & cnt_LOAD_LOS_TITLE & s & _
                cnt_LOAD_RES_TITLE
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
        
        'LOAD Calibration data
        strTemp = cnt_CAL_LOAD_TITLE & s & frmMain.Text_CalKitParam(14).Text
        For i = 15 To 17
            strTemp = strTemp & s & frmMain.Text_CalKitParam(i).Text
        Next i
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    Else
        'Standard Cal Kit OPEN Item Title
        strTemp = cnt_STDOITME_TITLE & s & cnt_OP_IMP_R_TITLE & s & cnt_OP_IMP_L_TITLE & s & cnt_OP_IMP_C_TITLE & s & s & s & s
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
        
        'OPEN Calibration data
        strTemp = cnt_CAL_OPEN_TITLE & s & frmMain.Text_CalKitParam(0).Text
        For i = 1 To 2
            strTemp = strTemp & s & frmMain.Text_CalKitParam(i).Text
        Next i
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
        'Standard Cal Kit SHORT Item Title
        strTemp = cnt_STDSITEM_TITLE & s & cnt_SH_IMP_R_TITLE & s & cnt_SH_IMP_L_TITLE & s & cnt_SH_IMP_C_TITLE & s & s & s & s
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
        'SHORT Calibration data
        strTemp = cnt_CAL_SHOR_TITLE & s & frmMain.Text_CalKitParam(7).Text
        For i = 8 To 9
            strTemp = strTemp & s & frmMain.Text_CalKitParam(i).Text
        Next i
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
        'Standard Cal Kit LOAD Item Title
        strTemp = cnt_STDLITEM_TITLE & s & cnt_LO_IMP_R_TITLE & s & cnt_LO_IMP_L_TITLE & s & cnt_LO_IMP_C_TITLE & s
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
        
        'LOAD Calibration data
        strTemp = cnt_CAL_LOAD_TITLE & s & frmMain.Text_CalKitParam(14).Text
        For i = 15 To 16
            strTemp = strTemp & s & frmMain.Text_CalKitParam(i).Text
        Next i
        lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    End If

    'Part Sweep Title
    strTemp = cnt_PRT_SWP__TITLE & s & cnt_PRT_SWS__TITLE & s & cnt_PRT_STP__TITLE & s & cnt_PRT_SPP__TITLE
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    'Part Sweep Setting
    Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, frmMain.Check_prt.Value)
    strTemp = cnt_PRT_SET__TITLE & s & str_sw & s & frmMain.Text_trg(0).Text & s & frmMain.Text_trg(1).Text
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)

    'Sweep Time (ms)
    strTemp = cnt_SWEEP_TM_TITLE & s & frmMain.Text_swt.Text
    If SwpTAt = 1 Then
        strTemp = strTemp & s & "AUTO"
    Else
        strTemp = strTemp & s & "MANUAL"
    End If
    lcnt = RdWtMeasData(fileno, lcnt, strTemp, s, cnt_SAVE)
    
    '************* Application ***************
    If cnt_CHECK_APPLI_NAME = AppName Then
        SaveMeasData = SaveNormal(fn, fileno, lcnt, s)
    ElseIf cnt_CHECK_APPLI_XTAL = AppName Then
        tmp = totalP: totalP = XtalCalPoint
        SaveMeasData = SaveXtal(fn, fileno, lcnt, s)
        totalP = tmp
    End If
    
    On Error GoTo 0
    Exit Function

ErrSaveFile:
    Close #fileno
    SaveMeasData = True
    MsgBox fn & "Error:" & str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    On Error GoTo 0
End Function

'
Private Sub SaveCalFile(fn As String)
    Dim fileno As Long
    Dim i As Integer

    fn = Mid(fn, 1, Len(fn) - 3)
    fn = fn & "bin"
    On Error GoTo svferr
    If FileDlg.FileExists(fn) = True Then
        Kill fn
    End If
    
    fileno = FreeFile
    '
    Open fn For Binary Access Write As #fileno Len = Len(cal1(0))
        For i = 0 To totalP - 1
            Put #fileno, , cal1(i * 2)
            Put #fileno, , cal1(i * 2 + 1)
            Put #fileno, , cal2(i * 2)
            Put #fileno, , cal2(i * 2 + 1)
            Put #fileno, , cal3(i * 2)
            Put #fileno, , cal3(i * 2 + 1)
        Next i
    Close #fileno
    On Error GoTo 0
    Exit Sub

svferr:
    MsgBox "Error:" & str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    Close #fileno
    On Error GoTo 0
End Sub

'
'The setting condition data and the measurement data is write in the CSV file.
'
Public Function SaveCsvFile(ByRef fn As String, ByRef AppName As String, ByRef RevNo As String) As Boolean
    Dim FileNum As Long
    Dim blnRtn As Boolean
    '
    SaveCsvFile = False
    FileNum = FreeFile
    Open fn For Output As #FileNum
        blnRtn = SaveMeasData(fn, FileNum, AppName, RevNo)
    Close #FileNum
    Call SaveCalFile(fn)
    SaveCsvFile = blnRtn
End Function

Public Sub SavingCsvFileDlg()
    Dim fn As String
    Dim bln As Boolean
    Dim CalChk As Long
    Dim stat As Long
    Dim lngErr As Long

    Call frmMain.get_Swr(0, totalP - 1)
        
    intFileSave = cnt_FILE_NOT_SV
    Call frmMain.Specified_disp_wave(frmMain.SSTab_DispFromat.Tab)
    
    fn = FileDlg.OpenFileDg(frmMain.dlgFILE, strPathFileAtt, "SAVE")    'OPEN save file dialogue
    
    If fn <> vbNullString Then      'If the file name was selected, the file is read.
        strPathFileAtt = RemoveFileSpec(fn)
        Call WriteIniFile_FileDlgPath(strPathFileAtt)
        Call ReadCalData
        bln = SaveCsvFile(fn, cnt_CHECK_APPLI_NAME, cnt_CSV_WRITE_VER300)
    End If
    
End Sub


Private Function ReadXtalMeasCondition(fn As String, fileno As Long) As Boolean
    Dim lcnt As Long
    Dim s As String
    Dim aryTemp As Variant
    Dim aryOverlap As Variant
    Dim strAppliName As String
    Dim strCsvVer As String
    Dim strBoardIdn As String
    Dim int_sw As Integer
    Dim Z0 As Double
    Dim strTmp As String
    Dim i As Integer
    Dim seg_cnt As Integer
    Dim RdBdId As Long
'    Dim n As Integer
    Dim Point As Long
    Dim tr As Integer
    Dim MinFreq As Double
    Dim MaxFreq As Double
    '
    ' It reads it from the CSV file.
    ' The read value is set to the variable.
    '
    ReadXtalMeasCondition = True

    On Error GoTo ErrReadXtalFile   'If file error is the specifies JUMP.
    '
    s = cnt_CSV_SEPA_CHAR
    
    lcnt = 0
    
    ' Application Name
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strAppliName = CStr(aryTemp(1))
    
    If UCase(strAppliName) <> UCase(cnt_CHECK_APPLI_XTAL) Then GoTo ErrReadXtalFile
    
    ' CSV Sheet Revsion
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strCsvVer = CDbl(aryTemp(1))
    
    ' Board Number
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    RdBdId = CLng(aryTemp(1))
    
    ' IP Address
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    If frmMain.Cmd_connect.Enabled = True Then
        frmMain.Text_con.Text = CStr(aryTemp(1))
    End If
    
    ' Product Name
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    NA_ProductName = CStr(aryTemp(1))
    If frmMain.Cmd_connect.Enabled = False Then
        If NA_ConnectProductName <> NA_ProductName Then
            MsgBox "Connect Product Name [ " & NA_ConnectProductName & " ]: " & vbCrLf & vbCrLf & _
                    "Read Product Name [ " & NA_ProductName & " ]", vbOKOnly Or vbCritical
            GoTo ErrXtalProductType
        End If
    End If
    
    BdId = RdBdId
    
    ' Serial Number
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    NA_SerialNumber = CStr(aryTemp(1))
    
    ' SW-BOX Type
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    If frmMain.Cmd_connect.Enabled <> True Then             ' Connect
        If strExpSwBoxType <> CStr(aryTemp(1)) Then
            MsgBox "Connect SW-BOX Name [ " & strExpSwBoxType & " ]: " & vbCrLf & vbCrLf & _
                        "Read SW-BOX Name [ " & aryTemp(1) & " ]", vbOKOnly Or vbCritical
            GoTo ErrXtalProductType
        Else
            strExpSwBoxType = CStr(aryTemp(1))
            If strExpSwBoxType = SWBOX_TYPE_DPDT Then
                Call ExpSwBoxType(lngExpSwBox, strExpSwBoxType, McrGetNo)
            End If
            If strExpSwBoxType = SWBOX_TYPE_SP4T Then
                Call ExpSwBoxType(lngExpSwBox, strExpSwBoxType, McrGetNo)
                SP4TPort(BdId, ActCh(BdId)) = CLng(aryTemp(2)) - 1
            End If
        End If
    Else
        strExpSwBoxType = CStr(aryTemp(1))
        If strExpSwBoxType = SWBOX_TYPE_DPDT Then
            Call ExpSwBoxType(lngExpSwBox, strExpSwBoxType, McrGetNo)
        End If
        If strExpSwBoxType = SWBOX_TYPE_SP4T Then
            Call ExpSwBoxType(lngExpSwBox, strExpSwBoxType, McrGetNo)
            SP4TPort(BdId, ActCh(BdId)) = CLng(aryTemp(2)) - 1
        End If
    End If
        

    ' Channel Title
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    ActCh(BdId) = CInt(Mid(aryTemp(1), 3, 1)) - 1
    frmMain.Combo_ch.ListIndex = ActCh(BdId)

    ' Electrical length correction (ON/OFF)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
    EleCorrStat = int_sw
    
    ' Electrical length correction (psec)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    EleCorrTime = CDbl(aryTemp(1)) * PS
    
    ' Electrical length correction (mm)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    EleCorrLength = CDbl(aryTemp(1)) * Millimeter
    
    ' Port Extension (ON/OFF)   <--- Add Rev 3.000
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
    PortExtStat = int_sw
    ' Port Extension (psec)     <--- Add Rev 3.000
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    PortExtTime = CDbl(aryTemp(1)) * PS
    ' Port Extension (mm)       <--- Add Rev 3.000
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    PortExtLength = CDbl(aryTemp(1)) * Millimeter
    
    ' Port Impedance (ohm)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Z0 = CDbl(aryTemp(1))
    frmMain.Text_z0.Text = Z0
    
    ' Parameter conversion (OFF Z:TRAN Y:TRAN Z:REFL Y:REFL 1/S)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    For i = 0 To frmMain.Combo_cnv.ListCount
        If strTmp = frmMain.Combo_cnv.List(i) Then
            frmMain.Combo_cnv.ListIndex = i
            Exit For
        End If
    Next i
   
    ' Calibration Title
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
   
    ' CAL status (ON/OFF)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
    RdCorOn = int_sw
    If UBound(aryTemp) = 6 Then         'CSV Ver. 1 correspond
        strGetCalDateTime = aryTemp(2)
        CorAcq(0) = CLng(aryTemp(3))
        CorAcq(1) = CLng(aryTemp(4))
        CorAcq(2) = CLng(aryTemp(5))
        CorAcq(3) = CLng(aryTemp(6))
    End If
    
    ' CAL status (Cor/C?/C!)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    frmMain.Text_hd(0).Text = CStr(aryTemp(1))
    If aryTemp(1) = "Cor" Then
        CorOn = 1
    ElseIf aryTemp(1) = "C?" Then
        CorOn = 2
    ElseIf aryTemp(1) = "C!" Then
        CorOn = 3
    Else
        CorOn = 0
    End If
   
    ' CAL Method (Norm/Trans/1 Port)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    For i = 0 To frmMain.Combo_cal.ListCount
        If strTmp = frmMain.Combo_cal.List(i) Then
            CorMeth = i
            Exit For
        End If
    Next i
    
    ' CAL Type (Don't@Care / User Define / 3.5mm / 3.5mm(R&S))
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    For i = 0 To frmMain.Combo_CalKitType.ListCount
        If strTmp = frmMain.Combo_CalKitType.List(i) Then
            CKit.CKitType = i
            Exit For
        End If
    Next i
  
    ' User Cal Kit Connect Type (Female/Male)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    For i = 0 To frmMain.OptPortSexType.UBound
        If strTmp = frmMain.OptPortSexType(i).Caption Then
            If i = 0 Then
                CKit.PortSex = BIS_FEMALE
            Else
                CKit.PortSex = BIS_MALE
            End If
            Exit For
        End If
    Next i
    
    If 0 < InStr(NA_ProductName, PN_R3760__) Then
        'User Cal Kit OPEN Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'OPEN Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_OpenZ0 To Unit_OpenCapC3
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i + 1)))
        Next i
        
        'User Cal Kit SHORT Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'SHORT Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_ShortZ0 To Unit_ShortIndL3
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i - Unit_OpenCapC3)))
        Next i
        
        'User Cal Kit LOAD Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'LOAD Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_LoadZ0 To Unit_LoadResistance
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i - Unit_ShortIndL3)))
        Next i
    Else
        'Standard Cal Kit OPEN Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'OPEN Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        Call SetStdCalKit_Data(XtalCKit, Unit_OpenR, CDbl(aryTemp(1)))
        Call SetStdCalKit_Data(XtalCKit, Unit_OpenL, CDbl(aryTemp(2)))
        Call SetStdCalKit_Data(XtalCKit, Unit_OpenC, CDbl(aryTemp(3)))
        
        'Standard Cal Kit SHORT Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'SHORT Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        Call SetStdCalKit_Data(XtalCKit, Unit_ShortR, CDbl(aryTemp(1)))
        Call SetStdCalKit_Data(XtalCKit, Unit_ShortL, CDbl(aryTemp(2)))
        Call SetStdCalKit_Data(XtalCKit, Unit_ShortC, CDbl(aryTemp(3)))
        
        'Standard Cal Kit LOAD Item Title
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        'LOAD Calibration data
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        Call SetStdCalKit_Data(XtalCKit, Unit_LoadR, CDbl(aryTemp(1)))
        Call SetStdCalKit_Data(XtalCKit, Unit_LoadL, CDbl(aryTemp(2)))
        Call SetStdCalKit_Data(XtalCKit, Unit_LoadC, CDbl(aryTemp(3)))
    End If
    
    'Part Sweep Title
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    'Part Sweep Setting
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
    PartSweep(BdId, ActCh(BdId)) = int_sw
    frmMain.Check_prt.Value = int_sw
    frmMain.Text_trg(0).Text = CStr(aryTemp(2))
    frmMain.Text_trg(1).Text = CStr(aryTemp(3))
 
    'Sweep Time (ms)
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    SwpTime = CDbl(aryTemp(1))
    If aryTemp(2) = "AUTO" Then
        SwpTAt = 1
    Else
        SwpTAt = 0
    End If
    
    'Measurement item Title
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)

    'Measurement item Setting
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
    frmEquMeas.Check_EquMeasItem(0).Value = int_sw
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(2)), int_sw)
    frmEquMeas.Check_EquMeasItem(1).Value = int_sw
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(3)), int_sw)
    frmEquMeas.Check_EquMeasItem(2).Value = int_sw
    
    'Result Limit Title
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    
    'Upper Limit
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    For i = LMT_C0_Index To LMT_FL_Index
        Call frmEquMeas.Xtal_up_lmt_disp(i, aryTemp(i + 1))
    Next i
    
    'Lower Limit
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    For i = LMT_C0_Index To LMT_FL_Index
        Call frmEquMeas.Xtal_lw_lmt_disp(i, aryTemp(i + 1))
    Next i
    
    ' Number of Freq.Segment
    MinFreq = 0: MaxFreq = 0
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    XtalSegCnt = CInt(aryTemp(1))
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    Point = 0
    For i = 0 To XtalSegCnt - 1
        lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
        With XtalBufSeg(i)
            .dblFreq1 = CDbl(aryTemp(1)) * Unit_k
            .dblFreq2 = CDbl(aryTemp(2))
            If .dblFreq2 <> 0 Then .dblFreq2 = .dblFreq2 * .dblFreq1 / Unit_mega
            .lngPntN = CLng(aryTemp(3))
            .lngFmode = BIS_FREQ_LIN
            .lngFtype = BIS_FREQ_STRSTP
            .sngPow1 = CDbl(aryTemp(4))
            .sngPow2 = CDbl(aryTemp(5))
            If aryTemp(4) = aryTemp(5) Then
                frmMain.Check_pw2.Value = 0
            Else
                frmMain.Check_pw2.Value = 1
            End If
            .sngRbw = CLng(CDbl(aryTemp(6)) * Unit_k)
            .sngStime = CDbl(aryTemp(7)) * Unit_m
            
            If MinFreq = 0 Then MinFreq = .dblFreq1
            If .dblFreq1 <= .dblFreq2 Then
                If .dblFreq1 < MinFreq Then MinFreq = .dblFreq1
                If MaxFreq < .dblFreq2 Then MaxFreq = .dblFreq2
            Else
                If .dblFreq2 < MinFreq Then MinFreq = .dblFreq2
                If MaxFreq < .dblFreq1 Then MaxFreq = .dblFreq1
            End If
        End With
        BufSeg(i) = XtalBufSeg(i)
        Point = Point + BufSeg(i).lngPntN
    Next i
    XtalCalPoint = Point - XtalBufSeg(XTAL_OTHER).lngPntN - XtalBufSeg(XTAL_FR).lngPntN
    totalP = XtalCalPoint

    'Measurement
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    For i = 0 To frmMain.Option_msr.UBound
        If frmMain.Option_msr(i).Caption = CStr(aryTemp(1)) Then
            frmMain.Option_msr(i).Value = True
            Exit For
        End If
    Next i
    If i = McrMeas_AR Then
        RdMeas = BIS_MEAS_AR
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeas__A Then
        RdMeas = BIS_MEAS_A
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeas__R Then
        RdMeas = BIS_MEAS_R
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeasS21 Then
        RdMeas = BIS_MEAS_S21
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeasS11 Then
        RdMeas = BIS_MEAS_S11
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeasS12 Then
        RdMeas = BIS_MEAS_S21
        DPDTPort(BdId, ActCh(BdId)) = i
    ElseIf i = McrMeasS22 Then
        RdMeas = BIS_MEAS_S11
        DPDTPort(BdId, ActCh(BdId)) = i
    End If
    
    'Device information
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    
    'f_nom [ ohm ]
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    XtalMeas.dblNomFreq = CDbl(aryTemp(1))
    XtalMeas.condition(XTAL_FL).dblCentFreq = XtalMeas.dblNomFreq
    
    'Label_DevInfo [ e-12 ] H
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
    XtalMeas.dblLoadCap = CDbl(aryTemp(1)) * Unit_p
    
    'Typ.CI [ ohm ]
    lcnt = RdWtMeasData(fileno, lcnt, aryTemp, s, cnt_READ)
     XtalMeas.dblTypicalCI = CDbl(aryTemp(1))
      
    ReadXtalMeasCondition = False
    
ErrXtalEnd:
    On Error GoTo 0 '*** ON ERROR reset ****
    Exit Function

ErrReadXtalFile:
    MsgBox fn & "Error line[ " & CLng(lcnt) & " ]: " + vbCrLf + vbCrLf + CStr(aryTemp(0)), vbOKOnly Or vbCritical
ErrXtalProductType:
    GoTo ErrXtalEnd

End Function

'
'The measurement condition of a tuning fork crystal unit is read from a CSV file.
'
Public Function ReadXtalCsvFile(fn As String) As Boolean
    Dim FileNum As Long
    Dim blnRtn As Boolean
    Dim fn_cal As String
    Dim Point As Long
    Dim tmp As Long
    Dim i As Long
    
    ReadXtalCsvFile = False
    FileNum = FreeFile
    Open fn For Input As #FileNum
        blnRtn = ReadXtalMeasCondition(fn, FileNum)
    Close #FileNum
    If blnRtn = False Then  'ReadXtalMeasCondition() -> False is a normal termination
        If RdCorOn And frmMain.Cmd_connect.Enabled = False Then ' Calibration ON and Connect BNA
            fn_cal = Mid(fn, 1, Len(fn) - 3)
            fn_cal = fn_cal & "bin"
            If FileDlg.FileExists(fn_cal) = True Then
                Call ReadCalFile(fn_cal)    'Read Calibration file
            Else
                RdCorOn = 0 ' Calibration OFF
                MsgBox "Error: Calibration file is not found " & fn_cal, vbOKOnly Or vbCritical
            End If
        End If
    End If
    ReadXtalCsvFile = blnRtn
End Function

